//	MemoryLink Class

//	include
#include "stdafx.h"
#include "MtoMSioDefs.h"

/*===================================================*/
//	MACRO
/*===================================================*/
#define EX_INT_CHECK_OPEN		if( !IsOpen() ){	return SIO_MTOM_ERR_CLOSED ;	}

/*===================================================*/
//	extern function
/*===================================================*/
extern void PumpMessage(DWORD dwMillisec = 0) ;

/*===================================================*/
//	Callback function
/*===================================================*/
//	NAK/ACK
static BOOL CALLBACK CB_ReceiveAckNak(LPVOID pClass,int* piRet,int* piDetail, LPVOID pParam)
{
	return ((CMemlinkSio*)pClass)->ReceiveAckNak( piRet, piDetail ) ;
}
//	GetContrast
static BOOL CALLBACK CB_ReceiveContrast(LPVOID pClass,int* piRet,int* piDetail, LPVOID pParam)
{
	return ((CMemlinkSio*)pClass)->ReceiveContrast( piRet, piDetail, (MEMLNK_ST_CONTRAST_REPLY*)pParam ) ;
}
//	Read
static BOOL CALLBACK CB_ReceiveRead(LPVOID pClass,int* piRet,int* piDetail, LPVOID pParam)
{
	return ((CMemlinkSio*)pClass)->ReceiveRead( piRet, piDetail, (MEMLNK_ST_R_REPLY*)pParam ) ;
}
//	interrupt
static BOOL CALLBACK CB_ReceiveInterrupt(LPVOID pClass,int* piRet,int* piDetail, LPVOID pParam)
{
	return ((CMemlinkSio*)pClass)->ReceiveInterrupt( piRet, piDetail, (MEMLNK_ST_I_REPLY*)pParam ) ;
}

/*===================================================*/
//	CMemlinkSio
//	---------------------------------------------------
//		Constructer
/*===================================================*/
CMemlinkSio::CMemlinkSio(LPMtoMSioConfig pstConfig)
{
	//	Socket
	m_pSock = new CSioSock(&pstConfig->stMemPortConfig) ;

	//	Setting
	memcpy( &m_stSetting, &pstConfig->stMemLinkSetting, sizeof(MtoMSioSetting) ) ;

	//	RxBuffer
	memset( m_RxBuf, 0, sizeof(m_RxBuf) ) ;
	m_iRxLen = 0 ;

	//	Error
	m_iErrDetail = 0 ;
}


/*===================================================*/
//	~CSioSock
//	---------------------------------------------------
//		Destructer
/*===================================================*/
CMemlinkSio::~CMemlinkSio(void)
{
	Close() ;

	delete m_pSock ;
}


/*===================================================*/
//	Open
//	---------------------------------------------------
//		Open the sio port
/*===================================================*/
bool CMemlinkSio::Open()
{
	if( m_pSock )
	{
		return m_pSock->Open() ;
	}

	ASSERT( 0 ) ;
	return false ;
}


/*===================================================*/
//	Close
//	---------------------------------------------------
//		Close the sio port
/*===================================================*/
void CMemlinkSio::Close()
{
	ASSERT( m_pSock ) ;

	if( m_pSock )
	{
		m_pSock->Close() ;
	}

	return ;
}


/*===================================================*/
//	IsOpen
//	---------------------------------------------------
//		Check sio state
/*===================================================*/
bool CMemlinkSio::IsOpen(void)
{
	if( m_pSock )
	{
		return m_pSock->IsOpen() ;
	}

	ASSERT( 0 ) ;
	return false ;
}



/*===================================================*/
//	ESC_W
//	---------------------------------------------------
//		Write to system area
/*===================================================*/
int CMemlinkSio::ESC_W(WORD wAddress,INT iDataCount,WORD* pwData)
{
	EX_INT_CHECK_OPEN ;

	INT iLenPos = 0 ;
	INT iIndex = 0;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = 'W' ;

	if( m_stSetting.bAscii )
	{
		//	ASCII
		iPos += AsciiHex( wAddress, 4, &TxBuf[iPos] ) ;
		iPos += AsciiHex( iDataCount, 4, &TxBuf[iPos] ) ;
		for( iIndex = 0; iIndex < iDataCount; iIndex++ )
		{
			iPos += AsciiHex( pwData[iIndex], 4, &TxBuf[iPos] ) ;
		}
	}
	else
	{
		//	Binary
		TxBuf[iPos++] = (BYTE)(wAddress/0x100) ;
		TxBuf[iPos++] = (BYTE)(wAddress&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iDataCount/0x100) ;
		TxBuf[iPos++] = (BYTE)(iDataCount&0xFF) ;
		for( iIndex = 0; iIndex < iDataCount; iIndex++ )
		{
			TxBuf[iPos++] = (BYTE)(pwData[iIndex]/0x100) ;
			TxBuf[iPos++] = (BYTE)(pwData[iIndex]&0xFF) ;
		}
	}

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	return Transmit( TxBuf, iPos, NULL, NULL ) ;
}


/*===================================================*/
//	ESC_R
//	---------------------------------------------------
//		Read from system area
/*===================================================*/
int CMemlinkSio::ESC_R(WORD wAddress,INT iDataCount,WORD* pwoData)
{
	EX_INT_CHECK_OPEN ;

	INT iLenPos = 0 ;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = 'R' ;

	if( m_stSetting.bAscii )
	{
		//	ASCII
		iPos += AsciiHex( wAddress, 4, &TxBuf[iPos] ) ;
		iPos += AsciiHex( iDataCount, 4, &TxBuf[iPos] ) ;
	}
	else
	{
		//	Binary
		TxBuf[iPos++] = (BYTE)(wAddress/0x100) ;
		TxBuf[iPos++] = (BYTE)(wAddress&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iDataCount/0x100) ;
		TxBuf[iPos++] = (BYTE)(iDataCount&0xFF) ;
	}

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	MEMLNK_ST_R_REPLY stReply ;
	stReply.iDataCount = iDataCount ;
	stReply.pwData = pwoData ;

	return Transmit( TxBuf, iPos, CB_ReceiveRead, &stReply ) ;
}


/*===================================================*/
//	ESC_T
//	---------------------------------------------------
//		Draw text
/*===================================================*/
int CMemlinkSio::ESC_T(GPCOLOR cDisplayColor,GPCOLOR cBackColor, INT iX1,INT iY1,GPFONTSIZE cFontSize,CHAR* szString)
{
	EX_INT_CHECK_OPEN ;

	INT iLenPos = 0 ;
	INT iStrPos = 0;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = 'T' ;

	if( m_stSetting.bAscii )
	{
		//	ASCII
		iPos += AsciiColor( cDisplayColor, &TxBuf[iPos] ) ;
		iPos += AsciiColor( cBackColor, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iX1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY1, 4, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = (BYTE)('0' + (cFontSize>>4)) ;
		TxBuf[iPos++] = (BYTE)('0' + (cFontSize&0x0F)) ;
		iLenPos = iPos ;
		iPos += 2 ;
		while( szString && szString[iStrPos] )
		{
			TxBuf[iPos++] = szString[iStrPos++] ;
		}
		AsciiDec( iPos-(iLenPos+2), 2, &TxBuf[iLenPos] ) ;
	}
	else
	{
		//	Binary
		TxBuf[iPos++] = cDisplayColor ;
		TxBuf[iPos++] = cBackColor ;
		TxBuf[iPos++] = (BYTE)(iX1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY1&0xFF) ;
		TxBuf[iPos++] = cFontSize ;
		iLenPos = iPos++ ;
		while( szString && szString[iStrPos] )
		{
			TxBuf[iPos++] = szString[iStrPos++] ;
		}
		TxBuf[iLenPos] = iPos-(iLenPos+1) ;
	}

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	return Transmit( TxBuf, iPos, NULL, NULL ) ;
}


/*===================================================*/
//	ESC_L
//	---------------------------------------------------
//		Draw line
/*===================================================*/
int CMemlinkSio::ESC_L(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iX2,INT iY2)
{
	EX_INT_CHECK_OPEN ;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = 'L' ;

	if( m_stSetting.bAscii )
	{
		//	ASCII
		iPos += AsciiColor( cDisplayColor, &TxBuf[iPos] ) ;
		iPos += AsciiColor( cBackColor, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = '0' ;
		iPos += AsciiDec( cLineStyle, 1, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iX1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iX2, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY2, 4, &TxBuf[iPos] ) ;
	}
	else
	{
		//	Binary
		TxBuf[iPos++] = cDisplayColor ;
		TxBuf[iPos++] = cBackColor ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = cLineStyle ;
		TxBuf[iPos++] = (BYTE)(iX1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iX2/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX2&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY2/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY2&0xFF) ;
	}

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	return Transmit( TxBuf, iPos, NULL, NULL ) ;
}


/*===================================================*/
//	ESC_B
//	---------------------------------------------------
//		Draw rectangle
/*===================================================*/
int CMemlinkSio::ESC_B(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iX2,INT iY2)
{
	EX_INT_CHECK_OPEN ;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = 'B' ;

	if( m_stSetting.bAscii )
	{
		//	ASCII
		iPos += AsciiColor( cDisplayColor, &TxBuf[iPos] ) ;
		iPos += AsciiColor( cBackColor, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = '0' ;
		iPos += AsciiDec( cLineStyle, 1, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iX1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iX2, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY2, 4, &TxBuf[iPos] ) ;
	}
	else
	{
		//	Binary
		TxBuf[iPos++] = cDisplayColor ;
		TxBuf[iPos++] = cBackColor ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = cLineStyle ;
		TxBuf[iPos++] = (BYTE)(iX1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iX2/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX2&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY2/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY2&0xFF) ;
	}

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	return Transmit( TxBuf, iPos, NULL, NULL ) ;
}


/*===================================================*/
//	ESC_S
//	---------------------------------------------------
//		Draw fill rectangle
/*===================================================*/
int CMemlinkSio::ESC_S(GPCOLOR cDisplayColor,GPCOLOR cBackColor,INT iX1,INT iY1,INT iX2,INT iY2,GPTILE cTile)
{
	EX_INT_CHECK_OPEN ;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = 'S' ;

	if( m_stSetting.bAscii )
	{
		//	ASCII
		iPos += AsciiColor( cDisplayColor, &TxBuf[iPos] ) ;
		iPos += AsciiColor( cBackColor, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = '0' ;
		iPos += AsciiDec( cTile, 1, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iX1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iX2, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY2, 4, &TxBuf[iPos] ) ;
	}
	else
	{
		//	Binary
		TxBuf[iPos++] = cDisplayColor ;
		TxBuf[iPos++] = cBackColor ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = cTile ;
		TxBuf[iPos++] = (BYTE)(iX1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iX2/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX2&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY2/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY2&0xFF) ;
	}

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	return Transmit( TxBuf, iPos, NULL, NULL ) ;
}


/*===================================================*/
//	ESC_C
//	---------------------------------------------------
//		Draw circle
/*===================================================*/
int CMemlinkSio::ESC_C(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius)
{
	EX_INT_CHECK_OPEN ;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = 'C' ;

	if( m_stSetting.bAscii )
	{
		//	ASCII
		iPos += AsciiColor( cDisplayColor, &TxBuf[iPos] ) ;
		iPos += AsciiColor( cBackColor, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = '0' ;
		iPos += AsciiDec( cLineStyle, 1, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iX1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iRadius, 4, &TxBuf[iPos] ) ;
	}
	else
	{
		//	Binary
		TxBuf[iPos++] = cDisplayColor ;
		TxBuf[iPos++] = cBackColor ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = cLineStyle ;
		TxBuf[iPos++] = (BYTE)(iX1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iRadius/0x100) ;
		TxBuf[iPos++] = (BYTE)(iRadius&0xFF) ;
	}

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	return Transmit( TxBuf, iPos, NULL, NULL ) ;
}


/*===================================================*/
//	ESC_A
//	---------------------------------------------------
//		Draw arc
/*===================================================*/
int CMemlinkSio::ESC_A(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius,INT iStartAngle,INT iEndAngle)
{
	EX_INT_CHECK_OPEN ;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = 'A' ;

	if( m_stSetting.bAscii )
	{
		//	ASCII
		iPos += AsciiColor( cDisplayColor, &TxBuf[iPos] ) ;
		iPos += AsciiColor( cBackColor, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = '0' ;
		iPos += AsciiDec( cLineStyle, 1, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iX1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iRadius, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iStartAngle, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iEndAngle, 4, &TxBuf[iPos] ) ;
	}
	else
	{
		//	Binary
		TxBuf[iPos++] = cDisplayColor ;
		TxBuf[iPos++] = cBackColor ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = cLineStyle ;
		TxBuf[iPos++] = (BYTE)(iX1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iRadius/0x100) ;
		TxBuf[iPos++] = (BYTE)(iRadius&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iStartAngle/0x100) ;
		TxBuf[iPos++] = (BYTE)(iStartAngle&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iEndAngle/0x100) ;
		TxBuf[iPos++] = (BYTE)(iEndAngle&0xFF) ;
	}

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	return Transmit( TxBuf, iPos, NULL, NULL ) ;
}


/*===================================================*/
//	ESC_G
//	---------------------------------------------------
//		Draw sector
/*===================================================*/
int CMemlinkSio::ESC_G(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius,INT iStartAngle,INT iEndAngle)
{
	EX_INT_CHECK_OPEN ;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = 'G' ;

	if( m_stSetting.bAscii )
	{
		//	ASCII
		iPos += AsciiColor( cDisplayColor, &TxBuf[iPos] ) ;
		iPos += AsciiColor( cBackColor, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = '0' ;
		iPos += AsciiDec( cLineStyle, 1, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iX1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iRadius, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iStartAngle, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iEndAngle, 4, &TxBuf[iPos] ) ;
	}
	else
	{
		//	Binary
		TxBuf[iPos++] = cDisplayColor ;
		TxBuf[iPos++] = cBackColor ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = cLineStyle ;
		TxBuf[iPos++] = (BYTE)(iX1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iRadius/0x100) ;
		TxBuf[iPos++] = (BYTE)(iRadius&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iStartAngle/0x100) ;
		TxBuf[iPos++] = (BYTE)(iStartAngle&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iEndAngle/0x100) ;
		TxBuf[iPos++] = (BYTE)(iEndAngle&0xFF) ;
	}

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	return Transmit( TxBuf, iPos, NULL, NULL ) ;
}


/*===================================================*/
//	ESC_I
//	---------------------------------------------------
//		Check interrupt
/*===================================================*/
int CMemlinkSio::ESC_I(BOOL* pbHave,DWORD *pdwCode)
{
	EX_INT_CHECK_OPEN ;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = 'I' ;

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	MEMLNK_ST_I_REPLY stReply = {0,0} ;
	int iRet = Transmit( TxBuf, iPos, CB_ReceiveContrast, NULL ) ;
	if( iRet == SIO_MTOM_OK )
	{
		*pbHave = ( stReply.wCount ) ? TRUE : FALSE ;
		*pdwCode = stReply.wData ;
	}

	return iRet ;
}


/*===================================================*/
//	ESC_t
//	---------------------------------------------------
//		Draw text
/*===================================================*/
int CMemlinkSio::ESC_t(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPFONT cFont,INT iTurn,INT iDirection,INT iHalfcentering,INT iEmphasis,GPCOLOR cSculptrue,INT iX1,INT iY1,GPFONTSIZE cFontSize,CHAR* szString)
{
	EX_INT_CHECK_OPEN ;

	INT iLenPos = 0 ;
	INT iStrPos = 0;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = 't' ;

	if( m_stSetting.bAscii )
	{
		//	ASCII
		iPos += AsciiColor( cDisplayColor, &TxBuf[iPos] ) ;
		iPos += AsciiColor( cBackColor, &TxBuf[iPos] ) ;
		iPos += AsciiDec( cFont, 2, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iTurn, 1, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iDirection, 1, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iHalfcentering, 1, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iEmphasis, 1, &TxBuf[iPos] ) ;
		iPos += AsciiColor( cSculptrue, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iX1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY1, 4, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = (BYTE)('0' + (cFontSize>>4)) ;
		TxBuf[iPos++] = (BYTE)('0' + (cFontSize&0x0F)) ;
		iLenPos = iPos ;
		iPos += 2 ;
		while( szString && szString[iStrPos] )
		{
			TxBuf[iPos++] = szString[iStrPos++] ;
		}
		AsciiDec( iPos-(iLenPos+2), 2, &TxBuf[iLenPos] ) ;
	}
	else
	{
		//	Binary
		TxBuf[iPos++] = cDisplayColor ;
		TxBuf[iPos++] = cBackColor ;
		TxBuf[iPos++] = cFont ;
		TxBuf[iPos++] = iTurn ;
		TxBuf[iPos++] = iDirection ;
		TxBuf[iPos++] = iHalfcentering ;
		TxBuf[iPos++] = iEmphasis ;
		TxBuf[iPos++] = cSculptrue ;
		TxBuf[iPos++] = (BYTE)(iX1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY1&0xFF) ;
		TxBuf[iPos++] = cFontSize ;
		iLenPos = iPos++ ;
		while( szString && szString[iStrPos] )
		{
			TxBuf[iPos++] = szString[iStrPos++] ;
		}
		TxBuf[iLenPos] = iPos-(iLenPos+1) ;
	}

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	return Transmit( TxBuf, iPos, NULL, NULL ) ;
}


/*===================================================*/
//	ESC_l
//	---------------------------------------------------
//		Draw line
/*===================================================*/
int CMemlinkSio::ESC_l(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iArrowPattern,INT iArrowDirection,INT iX1,INT iY1,INT iX2,INT iY2)
{
	EX_INT_CHECK_OPEN ;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = 'l' ;

	if( m_stSetting.bAscii )
	{
		//	ASCII
		iPos += AsciiColor( cDisplayColor, &TxBuf[iPos] ) ;
		iPos += AsciiColor( cBackColor, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = '0' ;
		iPos += AsciiDec( cLineStyle, 1, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = '0' ;
		TxBuf[iPos++] = '2' ;
		iPos += AsciiDec( iArrowPattern, 1, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iArrowDirection, 1, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iX1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iX2, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY2, 4, &TxBuf[iPos] ) ;
	}
	else
	{
		//	Binary
		TxBuf[iPos++] = cDisplayColor ;
		TxBuf[iPos++] = cBackColor ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = cLineStyle ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = 2 ;
		TxBuf[iPos++] = iArrowPattern ;
		TxBuf[iPos++] = iArrowDirection ;
		TxBuf[iPos++] = (BYTE)(iX1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iX2/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX2&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY2/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY2&0xFF) ;
	}

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	return Transmit( TxBuf, iPos, NULL, NULL ) ;
}


/*===================================================*/
//	ESC_b
//	---------------------------------------------------
//		Draw rectangle
/*===================================================*/
int CMemlinkSio::ESC_b(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iCornerDirection,INT iCornerRadius,INT iX1,INT iY1,INT iX2,INT iY2)
{
	EX_INT_CHECK_OPEN ;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = 'b' ;

	if( m_stSetting.bAscii )
	{
		//	ASCII
		iPos += AsciiColor( cDisplayColor, &TxBuf[iPos] ) ;
		iPos += AsciiColor( cBackColor, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = '0' ;
		iPos += AsciiDec( cLineStyle, 1, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = '0' ;
		TxBuf[iPos++] = '0' ;
		TxBuf[iPos++] = '0' ;
		iPos += AsciiDec( iCornerDirection, 1, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iCornerRadius, 2, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iX1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iX2, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY2, 4, &TxBuf[iPos] ) ;
	}
	else
	{
		//	Binary
		TxBuf[iPos++] = cDisplayColor ;
		TxBuf[iPos++] = cBackColor ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = cLineStyle ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = (BYTE)iCornerDirection ;
		TxBuf[iPos++] = (BYTE)(iCornerRadius/0x100) ;
		TxBuf[iPos++] = (BYTE)(iCornerRadius&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iX1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iX2/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX2&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY2/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY2&0xFF) ;
	}

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	return Transmit( TxBuf, iPos, NULL, NULL ) ;
}


/*===================================================*/
//	ESC_s
//	---------------------------------------------------
//		Draw fill rectangle
/*===================================================*/
int CMemlinkSio::ESC_s(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPTILE cTile,INT iCornerDirection,INT iCornerRadius,INT iX1,INT iY1,INT iX2,INT iY2)
{
	EX_INT_CHECK_OPEN ;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = 's' ;

	if( m_stSetting.bAscii )
	{
		//	ASCII
		iPos += AsciiColor( cDisplayColor, &TxBuf[iPos] ) ;
		iPos += AsciiColor( cBackColor, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = '0' ;
		TxBuf[iPos++] = '0' ;
		TxBuf[iPos++] = '0' ;
		iPos += AsciiDec( cTile, 1, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = '0' ;
		iPos += AsciiDec( iCornerDirection, 1, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iCornerRadius, 2, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iX1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iX2, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY2, 4, &TxBuf[iPos] ) ;
	}
	else
	{
		//	Binary
		TxBuf[iPos++] = cDisplayColor ;
		TxBuf[iPos++] = cBackColor ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = cTile ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = (BYTE)iCornerDirection ;
		TxBuf[iPos++] = (BYTE)(iCornerRadius/0x100) ;
		TxBuf[iPos++] = (BYTE)(iCornerRadius&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iX1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iX2/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX2&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY2/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY2&0xFF) ;
	}

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	return Transmit( TxBuf, iPos, NULL, NULL ) ;
}


/*===================================================*/
//	ESC_c
//	---------------------------------------------------
//		Draw circle
/*===================================================*/
int CMemlinkSio::ESC_c(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPTILE cTile,INT iX1,INT iY1,INT iRadius)
{
	EX_INT_CHECK_OPEN ;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = 'c' ;

	if( m_stSetting.bAscii )
	{
		//	ASCII
		iPos += AsciiColor( cDisplayColor, &TxBuf[iPos] ) ;
		iPos += AsciiColor( cBackColor, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = '0' ;
		TxBuf[iPos++] = '0' ;
		TxBuf[iPos++] = '0' ;
		iPos += AsciiDec( cTile, 1, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iX1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iRadius, 4, &TxBuf[iPos] ) ;
	}
	else
	{
		//	Binary
		TxBuf[iPos++] = cDisplayColor ;
		TxBuf[iPos++] = cBackColor ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = cTile ;
		TxBuf[iPos++] = (BYTE)(iX1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iRadius/0x100) ;
		TxBuf[iPos++] = (BYTE)(iRadius&0xFF) ;
	}

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	return Transmit( TxBuf, iPos, NULL, NULL ) ;
}


/*===================================================*/
//	ESC_g
//	---------------------------------------------------
//		Draw sector
/*===================================================*/
int CMemlinkSio::ESC_g(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius,INT iStartAngle,INT iEndAngle)
{
	EX_INT_CHECK_OPEN ;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = 'g' ;

	if( m_stSetting.bAscii )
	{
		//	ASCII
		iPos += AsciiColor( cDisplayColor, &TxBuf[iPos] ) ;
		iPos += AsciiColor( cBackColor, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = '0' ;
		iPos += AsciiDec( cLineStyle, 1, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = '0' ;
		TxBuf[iPos++] = '0' ;
		iPos += AsciiDec( iX1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iY1, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iRadius, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iStartAngle, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iEndAngle, 4, &TxBuf[iPos] ) ;
	}
	else
	{
		//	Binary
		TxBuf[iPos++] = cDisplayColor ;
		TxBuf[iPos++] = cBackColor ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = cLineStyle ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = (BYTE)(iX1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iX1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iY1/0x100) ;
		TxBuf[iPos++] = (BYTE)(iY1&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iRadius/0x100) ;
		TxBuf[iPos++] = (BYTE)(iRadius&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iStartAngle/0x100) ;
		TxBuf[iPos++] = (BYTE)(iStartAngle&0xFF) ;
		TxBuf[iPos++] = (BYTE)(iEndAngle/0x100) ;
		TxBuf[iPos++] = (BYTE)(iEndAngle&0xFF) ;
	}

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	return Transmit( TxBuf, iPos, NULL, NULL ) ;
}


/*===================================================*/
//	ESC_SetContrast
//	---------------------------------------------------
//		Set contrast
/*===================================================*/
int CMemlinkSio::ESC_SetContrast(DWORD dwContrast,DWORD dwLight) 
{
	//	set contrast
	int iRet = ESC_SetContrast_Sub( 0, (WORD)dwContrast ) ;
	if( iRet == SIO_MTOM_OK )
	{
		//	set bright
		iRet = ESC_SetContrast_Sub( 1, (WORD)dwLight ) ;
	}

	//	return
	return iRet ;
}


/*===================================================*/
//	ESC_GetContrast
//	---------------------------------------------------
//		Get contrast
/*===================================================*/
int CMemlinkSio::ESC_GetContrast(DWORD *dwContrast,DWORD *dwLight) 
{
	EX_INT_CHECK_OPEN ;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = '$' ;

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	MEMLNK_ST_CONTRAST_REPLY stReply = {0,0} ;
	int iRet = Transmit( TxBuf, iPos, CB_ReceiveContrast, &stReply ) ;
	if( iRet == SIO_MTOM_OK )
	{
		*dwContrast = stReply.wContrast ;
		*dwLight = stReply.wBright ;
	}

	return iRet ;
}


/*===================================================*/
//	ESC_Y
//	---------------------------------------------------
//		Draw polygon
/*===================================================*/
int CMemlinkSio::ESC_Y(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iPosCount,INT* piX,INT* piY)
{
	EX_INT_CHECK_OPEN ;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;
	INT iIndex = 0 ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = 'Y' ;

	if( m_stSetting.bAscii )
	{
		//	ASCII
		iPos += AsciiColor( cDisplayColor, &TxBuf[iPos] ) ;
		iPos += AsciiColor( cBackColor, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = '0' ;
		iPos += AsciiDec( cLineStyle, 1, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iPosCount, 4, &TxBuf[iPos] ) ;
		for( iIndex = 0; iIndex < iPosCount; iIndex++ )
		{
			iPos += AsciiDec( piX[iIndex], 4, &TxBuf[iPos] ) ;
			iPos += AsciiDec( piY[iIndex], 4, &TxBuf[iPos] ) ;
		}
	}
	else
	{
		//	Binary
		TxBuf[iPos++] = cDisplayColor ;
		TxBuf[iPos++] = cBackColor ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = cLineStyle ;
		TxBuf[iPos++] = (BYTE)(iPosCount/0x100) ;
		TxBuf[iPos++] = (BYTE)(iPosCount&0xFF) ;
		for( iIndex = 0; iIndex < iPosCount; iIndex++ )
		{
			TxBuf[iPos++] = (BYTE)(piX[iIndex]/0x100) ;
			TxBuf[iPos++] = (BYTE)(piX[iIndex]&0xFF) ;
			TxBuf[iPos++] = (BYTE)(piY[iIndex]/0x100) ;
			TxBuf[iPos++] = (BYTE)(piY[iIndex]&0xFF) ;
		}
	}

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	return Transmit( TxBuf, iPos, NULL, NULL ) ;
}


/*===================================================*/
//	ESC_y
//	---------------------------------------------------
//		Draw polygon
/*===================================================*/
int CMemlinkSio::ESC_y(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPTILE cTile,INT iPosCount,INT* piX,INT* piY)
{
	EX_INT_CHECK_OPEN ;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;
	INT iIndex = 0 ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = 'y' ;

	if( m_stSetting.bAscii )
	{
		//	ASCII
		iPos += AsciiColor( cDisplayColor, &TxBuf[iPos] ) ;
		iPos += AsciiColor( cBackColor, &TxBuf[iPos] ) ;
		TxBuf[iPos++] = '0' ;
		iPos += AsciiDec( cTile, 1, &TxBuf[iPos] ) ;
		iPos += AsciiDec( iPosCount, 4, &TxBuf[iPos] ) ;
		for( iIndex = 0; iIndex < iPosCount; iIndex++ )
		{
			iPos += AsciiDec( piX[iIndex], 4, &TxBuf[iPos] ) ;
			iPos += AsciiDec( piY[iIndex], 4, &TxBuf[iPos] ) ;
		}
	}
	else
	{
		//	Binary
		TxBuf[iPos++] = cDisplayColor ;
		TxBuf[iPos++] = cBackColor ;
		TxBuf[iPos++] = 0 ;
		TxBuf[iPos++] = cTile ;
		TxBuf[iPos++] = (BYTE)(iPosCount/0x100) ;
		TxBuf[iPos++] = (BYTE)(iPosCount&0xFF) ;
		for( iIndex = 0; iIndex < iPosCount; iIndex++ )
		{
			TxBuf[iPos++] = (BYTE)(piX[iIndex]/0x100) ;
			TxBuf[iPos++] = (BYTE)(piX[iIndex]&0xFF) ;
			TxBuf[iPos++] = (BYTE)(piY[iIndex]/0x100) ;
			TxBuf[iPos++] = (BYTE)(piY[iIndex]&0xFF) ;
		}
	}

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	return Transmit( TxBuf, iPos, NULL, NULL ) ;
}


/*===================================================*/
//	ESC_M
//	---------------------------------------------------
//		Show Message
//				not support
/*===================================================*/
int CMemlinkSio::ESC_M(GPCOLOR cDisplayColor,GPCOLOR cBackColor,BYTE bFontType,WORD wLanguage,BYTE bPriority,WCHAR* szString)
{
	return SIO_MTOM_ERROR_INVALID ;
}


/*===================================================*/
//	ESC_m
//	---------------------------------------------------
//		Stop Message
//				not support
/*===================================================*/
int CMemlinkSio::ESC_m(void)
{
	return SIO_MTOM_ERROR_INVALID ;
}


/*===================================================*/
//	GetLastError
//	---------------------------------------------------
//		Get Last Error
/*===================================================*/
int CMemlinkSio::GetLastError()
{
	return m_iErrDetail ;
}


/*===================================================*/
//	AddHead
//	---------------------------------------------------
//		Add header to the buffer
/*===================================================*/
INT CMemlinkSio::AddHead(BYTE* TxBuf)
{
	INT iLen = 0 ;

	if( !m_stSetting.bOneByOne )
	{
		TxBuf[iLen++] = MEMLNK_DEF_ENQ ;
		//	1:n
		if( m_stSetting.bAscii )
		{
			//	1:n ASCII
			iLen += AsciiHex( m_stSetting.byMachineNum, 2, &TxBuf[iLen] ) ;
		}
		else
		{
			//	1:n Bin
			TxBuf[iLen++] = m_stSetting.byMachineNum ;
		}
	}

	return iLen ;
}


/*===================================================*/
//	AddFoot
//	---------------------------------------------------
//		Add footer to the buffer
/*===================================================*/
INT CMemlinkSio::AddFoot(BYTE* TxBuf, INT iLen)
{
	INT iFootLen = 0 ;
	INT iSkipLen = m_stSetting.bOneByOne? 0 : 1 ;
	
	if( m_stSetting.bAscii )
	{
		//	ASCII
		if( m_stSetting.bExtCheckSum )
		{
			//	need check sum
			BYTE bySum = CalculateChecksum( &TxBuf[iSkipLen], iLen - iSkipLen ) ;
			iFootLen += AsciiHex( bySum, 2, &TxBuf[iLen+iFootLen] ) ;
		}

		//	CR
		TxBuf[iLen+(iFootLen++)] = MEMLNK_DEF_CR ;

		//	LF
		if( m_stSetting.bCrLf )
		{
			TxBuf[iLen+(iFootLen++)] = MEMLNK_DEF_LF ;
		}
	}
	else
	{
		//	Bin
		if( m_stSetting.bExtCheckSum )
		{
			//	need check sum
			TxBuf[iLen+(iFootLen++)] = CalculateChecksum( &TxBuf[iSkipLen], iLen - iSkipLen ) ;
		}
	}

	return iFootLen ;
}


/*===================================================*/
//	ReceiveAckNak
//	---------------------------------------------------
//		Receive Callback for wait ACK/NAK
/*===================================================*/
BOOL CMemlinkSio::ReceiveAckNak(int* piRet,int* piDetail)
{
	//	find head
	int iHead ;
	for( iHead = 0; iHead < m_iRxLen; iHead++ )
	{
		if( (m_RxBuf[iHead] == MEMLNK_DEF_ACK) ||
			(m_RxBuf[iHead] == MEMLNK_DEF_NAK) )
		{
			break ;
		}
	}

	if( iHead >= m_iRxLen )
	{	//	not yet
		m_iRxLen = 0 ;
		return FALSE ;
	}

	//	shift
	m_iRxLen = ShiftBuffer( m_RxBuf, m_iRxLen, iHead ) ;

	if( *m_RxBuf == MEMLNK_DEF_ACK )
	{	//	ACK	
		int iDelLen = 0 ;
		if( !ReceiveAck( m_RxBuf, m_iRxLen, &iDelLen ) )
		{
			if( iDelLen == 0 )
			{
				return FALSE ;
			}
			m_iRxLen = ShiftBuffer( m_RxBuf, m_iRxLen, iDelLen ) ;
			return ReceiveAckNak( piRet, piDetail ) ;
		}

		*piRet = SIO_MTOM_OK ;
		*piDetail = SIO_MTOM_OK ;
	}
	else
	{
		//	NAK
		BYTE byErr = 0xFF;
		int iDelLen = 0 ;
		if( !ReceiveNak( m_RxBuf, m_iRxLen, &byErr, &iDelLen ) )
		{
			if( iDelLen == 0 )
			{
				return FALSE ;
			}
			m_iRxLen = ShiftBuffer( m_RxBuf, m_iRxLen, iDelLen ) ;
			return ReceiveAckNak( piRet, piDetail ) ;
		}

		*piRet = SIO_MTOM_ERROR_NAK ;
		*piDetail = byErr ;
	}

	return TRUE ;
}


/*===================================================*/
//	ReceiveAckAscii
//	---------------------------------------------------
//		Receive Callback for wait ACK
/*===================================================*/
BOOL CMemlinkSio::ReceiveAck(BYTE* pBuffer,int iLength, int *pDelLen)
{
	if( m_stSetting.bAscii )
	{
		return ReceiveAckAscii( pBuffer, iLength, pDelLen) ;
	}

	return ReceiveAckBin( pBuffer, iLength, pDelLen) ;
}


/*===================================================*/
//	ReceiveAckAscii
//	---------------------------------------------------
//		Receive Callback for wait ACK
/*===================================================*/
BOOL CMemlinkSio::ReceiveAckAscii(BYTE* pBuffer,int iLength, int *pDelLen)
{
	ASSERT( *pBuffer == MEMLNK_DEF_ACK ) ;

	*pDelLen = 0 ;

	//	check length
	int iAckLen = 2, iCrPos = 1;
	if( m_stSetting.bCrLf )
	{
		iAckLen ++ ;
	}
	if( !m_stSetting.bOneByOne )
	{
		iAckLen += 2 ;
		iCrPos += 2 ;
	}
	if( iLength < iAckLen )
	{
		//	not yet
		return FALSE ;
	}

	//	check terminator
	*pDelLen = 1 ;
	if( (pBuffer[iCrPos] != MEMLNK_DEF_CR) ||
		(m_stSetting.bCrLf && (pBuffer[iCrPos+1] != MEMLNK_DEF_LF) ) )
	{
		//	Terminator error
		return FALSE ;
	}

	*pDelLen = iAckLen ;
	//	check MachineNum
	if( (!m_stSetting.bOneByOne) &&
		(!CheckMachineNum( &pBuffer[1] )) )
	{
		return FALSE ;
	}

	return TRUE ;
}


/*===================================================*/
//	ReceiveAckBin
//	---------------------------------------------------
//		Receive Callback for wait ACK
/*===================================================*/
BOOL CMemlinkSio::ReceiveAckBin(BYTE* pBuffer,int iLength, int *pDelLen)
{
	ASSERT( *pBuffer == MEMLNK_DEF_ACK ) ;

	if( m_stSetting.bOneByOne )
	{
		*pDelLen = 1 ;
		return TRUE ;
	}


	BYTE pExpBuf[MEMLNK_DEF_BUFFER_SIZE*2] = {0} ;
	INT iExpLen = ExpDualization( pBuffer, iLength, pExpBuf ) ;

	//	check length
	*pDelLen = 0 ;
	if( iExpLen < 2 )
	{
		return FALSE ;
	}

	*pDelLen = 2 ;
	if( pBuffer[1] == MEMLNK_DEF_STX )
	{
		*pDelLen = 3 ;
	}
	//	check MachineNum
	if( pBuffer[1] != m_stSetting.byMachineNum )
	{
		return FALSE ;
	}

	return TRUE ;
}


/*===================================================*/
//	ReceiveNakAscii
//	---------------------------------------------------
//		Receive Callback for wait NAK
/*===================================================*/
BOOL CMemlinkSio::ReceiveNak(BYTE* pBuffer,int iLength, BYTE* pbyErr, int *pDelLen)
{
	if( m_stSetting.bAscii )
	{
		return ReceiveNakAscii( pBuffer, iLength, pbyErr, pDelLen ) ;
	}

	return ReceiveNakBin( pBuffer, iLength, pbyErr, pDelLen ) ;
}


/*===================================================*/
//	ReceiveNakAscii
//	---------------------------------------------------
//		Receive Callback for wait NAK
/*===================================================*/
BOOL CMemlinkSio::ReceiveNakAscii(BYTE* pBuffer,int iLength, BYTE* pbyErr, int *pDelLen)
{
	ASSERT( *pBuffer == MEMLNK_DEF_NAK ) ;

	*pDelLen = 0 ;

	//	check length
	int iNakLen = 4, iCrPos = 3;
	if( m_stSetting.bCrLf )
	{
		iNakLen ++ ;
	}
	if( !m_stSetting.bOneByOne )
	{
		iNakLen += 2 ;
		iCrPos += 2 ;
	}
	if( iLength < iNakLen )
	{
		//	not yet
		return FALSE ;
	}

	//	check terminator
	*pDelLen = 1 ;
	if( (pBuffer[iCrPos] != MEMLNK_DEF_CR) ||
		(m_stSetting.bCrLf && (pBuffer[iCrPos+1] != MEMLNK_DEF_LF) ) )
	{
		//	Terminator error
		return FALSE ;
	}

	*pDelLen = iNakLen ;
	//	check MachineNum
	if( (!m_stSetting.bOneByOne) &&
		(!CheckMachineNum( &pBuffer[1] )) )
	{
		return FALSE ;
	}

	//	Set Error
	int iErr = 0xFF;
	char strErr[3] = {0} ;
	memcpy( strErr, &pBuffer[iCrPos-2], 2 ) ;
	sscanf( strErr, "%X", &iErr ) ;
	*pbyErr = (BYTE)iErr ;

	return TRUE ;
}


/*===================================================*/
//	ReceiveNakBin
//	---------------------------------------------------
//		Receive Callback for wait NAK
/*===================================================*/
BOOL CMemlinkSio::ReceiveNakBin(BYTE* pBuffer,int iLength, BYTE* pbyErr, int *pDelLen)
{
	ASSERT( *pBuffer == MEMLNK_DEF_NAK ) ;

	if( m_stSetting.bOneByOne )
	{
		*pDelLen = 1 ;
		*pbyErr = pBuffer[1] ;
		return TRUE ;
	}

	BYTE pExpBuf[MEMLNK_DEF_BUFFER_SIZE*2] = {0} ;
	INT iExpLen = ExpDualization( pBuffer, iLength, pExpBuf ) ;

	//	check length
	*pDelLen = 0 ;
	if( iExpLen < 2 )
	{
		return FALSE ;
	}

	*pDelLen = 3 ;
	if( pBuffer[1] == MEMLNK_DEF_STX )
	{
		*pDelLen = 3 ;
	}
	//	check MachineNum
	if( pBuffer[1] != m_stSetting.byMachineNum )
	{
		return FALSE ;
	}

	*pbyErr = pBuffer[2] ;

	return TRUE ;
}


/*===================================================*/
//	ReceiveContrast
//	---------------------------------------------------
//		Receive Callback for wait Contrast reply
/*===================================================*/
BOOL CMemlinkSio::ReceiveContrast(int* piRet,int* piDetail, MEMLNK_ST_CONTRAST_REPLY* pstReply)
{
	//	find head
	int iHead ;
	BYTE byStart = m_stSetting.bOneByOne ? MEMLNK_DEF_ESC : MEMLNK_DEF_STX ;
	for( iHead = 0; iHead < m_iRxLen; iHead++ )
	{
		if( (m_RxBuf[iHead] == byStart) ||
			(m_RxBuf[iHead] == MEMLNK_DEF_NAK))
		{
			break ;
		}
	}

	if( iHead >= m_iRxLen )
	{
		//	not yet
		m_iRxLen = 0 ;
		return FALSE ;
	}

	//	Shift
	m_iRxLen = ShiftBuffer( m_RxBuf, m_iRxLen, iHead ) ;

	//	NAK
	BOOL bRet = FALSE ;
	int iDelLen = 0;
	if( *m_RxBuf == MEMLNK_DEF_NAK )
	{
		BYTE byErr ;
		bRet = ReceiveNak( m_RxBuf, m_iRxLen, &byErr, &iDelLen ) ;
		if( bRet )
		{
			*piRet = SIO_MTOM_ERROR_NAK ;
			*piDetail = byErr ;
		}
		else
		{
			m_iRxLen = ShiftBuffer( m_RxBuf, m_iRxLen, iDelLen ) ;
		}
	}
	else 
	{
		if( m_stSetting.bAscii )
		{	//	ASCII
			bRet = ReceiveContrastAscii( m_RxBuf, m_iRxLen, pstReply, &iDelLen ) ;
		}
		else
		{	//	BIN
			bRet = ReceiveContrastBin( m_RxBuf, m_iRxLen, pstReply, &iDelLen ) ;
		}
	
		if( bRet )
		{
			*piRet = SIO_MTOM_OK ;
			*piDetail = SIO_MTOM_OK ;
		}
	}

	if( !bRet )
	{
		m_iRxLen = ShiftBuffer( m_RxBuf, m_iRxLen, iDelLen ) ;
		if( iDelLen == 0 )
		{
			return FALSE ;
		}
		return ReceiveContrast( piRet, piDetail, pstReply ) ;
	}

	return TRUE ;
}


/*===================================================*/
//	ReceiveContrastAscii
//	---------------------------------------------------
//		Receive Callback for wait Contrast reply
/*===================================================*/
BOOL CMemlinkSio::ReceiveContrastAscii(BYTE* pBuffer,int iLength, MEMLNK_ST_CONTRAST_REPLY* pstReply, int *pDelLen)
{
	bool bContrast = false ;
	*pDelLen = 0 ;
	int iCrPos = 10, iLen = 11 ;
	if( m_stSetting.bCrLf )
	{
		iLen++ ;
	}
	if( m_stSetting.bOneByOne )
	{
		if( iLength <= 1 )
		{	//	not yet
			return FALSE ;
		}
		bContrast = (pBuffer[1] == 'D') ? true : false ;
	}
	else
	{
		if( iLength <= 4 )
		{	//	not yet
			return FALSE ;
		}
		if( (CheckMachineNum(&pBuffer[1])) &&
			(pBuffer[3] == MEMLNK_DEF_ESC) &&
			(pBuffer[4] == 'D') )
		{
			bContrast = true ;
		}
		iLen += 3 ;
		iCrPos += 3 ;
	}

	if( bContrast && (iLength < iLen) )
	{	//	not yet
		return FALSE ;
	}

	*pDelLen = 1 ;
	if( !bContrast )
	{	//	not wait command
		return FALSE ;
	}

	if( (pBuffer[iCrPos] != MEMLNK_DEF_CR) ||
		(m_stSetting.bCrLf && (pBuffer[iCrPos+1] != MEMLNK_DEF_LF)) )
	{	//	terminate error
		return FALSE ;
	}

	pBuffer += 2 ;
	if( !m_stSetting.bOneByOne )
	{
		pBuffer += 3 ;
	}

	char strValue[5] ={0} ;
	int iVal ;
	memcpy( strValue, pBuffer, 4) ;
	sscanf( strValue, "%X", &iVal ) ;
	pstReply->wContrast = (WORD)iVal ;
	memcpy( strValue, pBuffer+4, 4) ;
	sscanf( strValue, "%X", &iVal ) ;
	pstReply->wBright = (WORD)iVal ;

	return TRUE ;
}


/*===================================================*/
//	ReceiveContrastBin
//	---------------------------------------------------
//		Receive Callback for wait Contrast reply
/*===================================================*/
BOOL CMemlinkSio::ReceiveContrastBin(BYTE* pBuffer,int iLength, MEMLNK_ST_CONTRAST_REPLY* pstReply, int *pDelLen)
{
	bool bContrast = false ;
	*pDelLen = 0 ;
	int iLen = 6 ;

	BYTE pExpBuf[MEMLNK_DEF_BUFFER_SIZE*2] = {0} ;
	INT iExpLen = ExpDualization( pBuffer, iLength, pExpBuf ) ;

	if( m_stSetting.bOneByOne )
	{
		if( iExpLen <= 1 )
		{	//	not yet
			return FALSE ;
		}
		bContrast = (pExpBuf[1] == 'D') ? true : false ;
	}
	else
	{
		if( iExpLen <= 4 )
		{	//	not yet
			return FALSE ;
		}
		if( (CheckMachineNum(&pBuffer[1])) &&
			(pExpBuf[2] == MEMLNK_DEF_ESC) &&
			(pExpBuf[3] == 'D') )
		{
			bContrast = true ;
		}
		iLen += 2 ;
	}

	if( bContrast && (iExpLen < iLen) )
	{	//	not yet
		return FALSE ;
	}

	*pDelLen = 1 ;
	if( !bContrast )
	{	//	not wait command
		return FALSE ;
	}

	BYTE* pPos = pExpBuf + 2 ;
	if( !m_stSetting.bOneByOne )
	{
		pPos += 2 ;
	}

	pstReply->wContrast = (*pPos * 0x0100) + *(pPos+1) ;
	pPos += 2 ;
	pstReply->wBright =	  (*pPos * 0x0100) + *(pPos+1) ;

	return TRUE ;
}


/*===================================================*/
//	ReceiveRead
//	---------------------------------------------------
//		Receive Callback for wait Read reply
/*===================================================*/
BOOL CMemlinkSio::ReceiveRead(int* piRet,int* piDetail, MEMLNK_ST_R_REPLY* pstReply)
{
	//	find head
	int iHead ;
	BYTE byStart = m_stSetting.bOneByOne ? MEMLNK_DEF_ESC : MEMLNK_DEF_STX ;
	for( iHead = 0; iHead < m_iRxLen; iHead++ )
	{
		if( (m_RxBuf[iHead] == byStart) ||
			(m_RxBuf[iHead] == MEMLNK_DEF_NAK))
		{
			break ;
		}
	}

	if( iHead >= m_iRxLen )
	{
		//	not yet
		m_iRxLen = 0 ;
		return FALSE ;
	}

	//	Shift
	m_iRxLen = ShiftBuffer( m_RxBuf, m_iRxLen, iHead ) ;

	//	NAK
	BOOL bRet = FALSE ;
	int iDelLen = 0;
	if( *m_RxBuf == MEMLNK_DEF_NAK )
	{
		BYTE byErr ;
		bRet = ReceiveNak( m_RxBuf, m_iRxLen, &byErr, &iDelLen ) ;
		if( bRet )
		{
			*piRet = SIO_MTOM_ERROR_NAK ;
			*piDetail = byErr ;
		}
		else
		{
			m_iRxLen = ShiftBuffer( m_RxBuf, m_iRxLen, iDelLen ) ;
		}
	}
	else 
	{
		if( m_stSetting.bAscii )
		{	//	ASCII
			bRet = ReceiveReadAscii( m_RxBuf, m_iRxLen, pstReply, &iDelLen ) ;
		}
		else
		{	//	BIN
			bRet = ReceiveReadBin( m_RxBuf, m_iRxLen, pstReply, &iDelLen ) ;
		}
	
		if( bRet )
		{
			*piRet = SIO_MTOM_OK ;
			*piDetail = SIO_MTOM_OK ;
		}
	}

	if( !bRet )
	{
		m_iRxLen = ShiftBuffer( m_RxBuf, m_iRxLen, iDelLen ) ;
		if( iDelLen == 0 )
		{
			return FALSE ;
		}
		return ReceiveRead( piRet, piDetail, pstReply ) ;
	}

	return TRUE ;
}


/*===================================================*/
//	ReceiveReadAscii
//	---------------------------------------------------
//		Receive Callback for wait Read reply
/*===================================================*/
BOOL CMemlinkSio::ReceiveReadAscii(BYTE* pBuffer,int iLength, MEMLNK_ST_R_REPLY* pstReply, int *pDelLen)
{
	bool bRead = false ;
	*pDelLen = 0 ;
	int iCrPos = 2+(4*pstReply->iDataCount), iLen = iCrPos+1 ;
	if( m_stSetting.bCrLf )
	{
		iLen++ ;
	}
	if( m_stSetting.bOneByOne )
	{
		if( iLength <= 1 )
		{	//	not yet
			return FALSE ;
		}
		bRead = (pBuffer[1] == 'A') ? true : false ;
	}
	else
	{
		if( iLength <= 4 )
		{	//	not yet
			return FALSE ;
		}
		if( (CheckMachineNum(&pBuffer[1])) &&
			(pBuffer[3] == MEMLNK_DEF_ESC) &&
			(pBuffer[4] == 'A') )
		{
			bRead = true ;
		}
		iLen += 3 ;
		iCrPos += 3 ;
	}

	if( bRead && (iLength < iLen) )
	{	//	not yet
		return FALSE ;
	}

	*pDelLen = 1 ;
	if( !bRead )
	{	//	not wait command
		return FALSE ;
	}

	if( (pBuffer[iCrPos] != MEMLNK_DEF_CR) ||
		(m_stSetting.bCrLf && (pBuffer[iCrPos+1] != MEMLNK_DEF_LF)) )
	{	//	terminate error
		return FALSE ;
	}

	pBuffer += 2 ;
	if( !m_stSetting.bOneByOne )
	{
		pBuffer += 3 ;
	}
	char strValue[5] ={0} ;
	int iVal ;
	for( int iIndex = 0; iIndex < pstReply->iDataCount; iIndex++ )
	{
		memcpy( strValue, &pBuffer[iIndex*4], 4) ;
		sscanf( strValue, "%X", &iVal ) ;
		pstReply->pwData[iIndex] = (WORD)iVal ;
	}

	return TRUE ;
}


/*===================================================*/
//	ReceiveReadBin
//	---------------------------------------------------
//		Receive Callback for wait Read reply
/*===================================================*/
BOOL CMemlinkSio::ReceiveReadBin(BYTE* pBuffer,int iLength, MEMLNK_ST_R_REPLY* pstReply, int *pDelLen)
{
	bool bRead = false ;
	*pDelLen = 0 ;
	int iLen = 2+(2*pstReply->iDataCount) ;


	BYTE pExpBuf[MEMLNK_DEF_BUFFER_SIZE*2] = {0} ;
	INT iExpLen = ExpDualization( pBuffer, iLength, pExpBuf ) ;

	if( m_stSetting.bOneByOne )
	{
		if( iExpLen <= 1 )
		{	//	not yet
			return FALSE ;
		}
		bRead = (pExpBuf[1] == 'A') ? true : false ;
	}
	else
	{
		if( iExpLen <= 4 )
		{	//	not yet
			return FALSE ;
		}
		if( (CheckMachineNum(&pBuffer[1])) &&
			(pExpBuf[2] == MEMLNK_DEF_ESC) &&
			(pExpBuf[3] == 'A') )
		{
			bRead = true ;
		}
		iLen += 2 ;
	}

	if( bRead && (iExpLen < iLen) )
	{	//	not yet
		return FALSE ;
	}

	*pDelLen = 1 ;
	if( !bRead )
	{	//	not wait command
		return FALSE ;
	}

	BYTE* pPos = pExpBuf + 2 ;
	if( !m_stSetting.bOneByOne )
	{
		pPos += 2 ;
	}

	for( int iIndex = 0; iIndex < pstReply->iDataCount; iIndex++ )
	{
		pstReply->pwData[iIndex] = (pPos[2*iIndex] * 0x0100) + pPos[(2*iIndex)+1] ;
	}

	return TRUE ;
}


/*===================================================*/
//	ReceiveInterrupt
//	---------------------------------------------------
//		Receive Callback for wait Interrupt reply
/*===================================================*/
BOOL CMemlinkSio::ReceiveInterrupt(int* piRet,int* piDetail, MEMLNK_ST_I_REPLY* pstReply)
{
	//	find head
	int iHead ;
	BYTE byStart = m_stSetting.bOneByOne ? MEMLNK_DEF_ESC : MEMLNK_DEF_STX ;
	for( iHead = 0; iHead < m_iRxLen; iHead++ )
	{
		if( (m_RxBuf[iHead] == byStart) ||
			(m_RxBuf[iHead] == MEMLNK_DEF_NAK))
		{
			break ;
		}
	}

	if( iHead >= m_iRxLen )
	{
		//	not yet
		m_iRxLen = 0 ;
		return FALSE ;
	}

	//	Shift
	m_iRxLen = ShiftBuffer( m_RxBuf, m_iRxLen, iHead ) ;

	//	NAK
	BOOL bRet = FALSE ;
	int iDelLen = 0;
	if( *m_RxBuf == MEMLNK_DEF_NAK )
	{
		BYTE byErr ;
		bRet = ReceiveNak( m_RxBuf, m_iRxLen, &byErr, &iDelLen ) ;
		if( bRet )
		{
			*piRet = SIO_MTOM_ERROR_NAK ;
			*piDetail = byErr ;
		}
		else
		{
			m_iRxLen = ShiftBuffer( m_RxBuf, m_iRxLen, iDelLen ) ;
		}
	}
	else 
	{
		if( m_stSetting.bAscii )
		{	//	ASCII
			bRet = ReceiveInterruptAscii( m_RxBuf, m_iRxLen, pstReply, &iDelLen ) ;
		}
		else
		{	//	BIN
			bRet = ReceiveInterruptBin( m_RxBuf, m_iRxLen, pstReply, &iDelLen ) ;
		}
	
		if( bRet )
		{
			*piRet = SIO_MTOM_OK ;
			*piDetail = SIO_MTOM_OK ;
		}
	}

	if( !bRet )
	{
		m_iRxLen = ShiftBuffer( m_RxBuf, m_iRxLen, iDelLen ) ;
		if( iDelLen == 0 )
		{
			return FALSE ;
		}
		return ReceiveInterrupt( piRet, piDetail, pstReply ) ;
	}

	return TRUE ;
}


/*===================================================*/
//	ReceiveInterrupt
//	---------------------------------------------------
//		Receive Callback for wait Interrupt reply
/*===================================================*/
BOOL CMemlinkSio::ReceiveInterruptAscii(BYTE* pBuffer,int iLength, MEMLNK_ST_I_REPLY* pstReply, int *pDelLen)
{
	bool bInterrupt = false ;
	*pDelLen = 0 ;
	int iCrPos = 6, iLen = 7 ;
	if( m_stSetting.bCrLf )
	{
		iLen++ ;
	}
	if( m_stSetting.bOneByOne )
	{
		if( iLength <= 1 )
		{	//	not yet
			return FALSE ;
		}
		bInterrupt = (pBuffer[1] == 'I') ? true : false ;
	}
	else
	{
		if( iLength <= 4 )
		{	//	not yet
			return FALSE ;
		}
		if( (CheckMachineNum(&pBuffer[1])) &&
			(pBuffer[3] == MEMLNK_DEF_ESC) &&
			(pBuffer[4] == 'I') )
		{
			bInterrupt = true ;
		}
		iLen += 3 ;
		iCrPos += 3 ;
	}

	if( bInterrupt && (iLength < iLen) )
	{	//	not yet
		return FALSE ;
	}

	*pDelLen = 1 ;
	if( !bInterrupt )
	{	//	not wait command
		return FALSE ;
	}

	if( (pBuffer[iCrPos] != MEMLNK_DEF_CR) ||
		(m_stSetting.bCrLf && (pBuffer[iCrPos+1] != MEMLNK_DEF_LF)) )
	{	//	terminate error
		return FALSE ;
	}

	pBuffer += 2 ;
	if( !m_stSetting.bOneByOne )
	{
		pBuffer += 3 ;
	}

	char strValue[3] ={0} ;
	int iVal ;
	memcpy( strValue, pBuffer, 2) ;
	sscanf( strValue, "%X", &iVal ) ;
	pstReply->wCount = (WORD)iVal ;
	memcpy( strValue, pBuffer+2, 2) ;
	sscanf( strValue, "%X", &iVal ) ;
	pstReply->wData = (WORD)iVal ;

	return TRUE ;
}


/*===================================================*/
//	ReceiveInterrupt
//	---------------------------------------------------
//		Receive Callback for wait Interrupt reply
/*===================================================*/
BOOL CMemlinkSio::ReceiveInterruptBin(BYTE* pBuffer,int iLength, MEMLNK_ST_I_REPLY* pstReply, int *pDelLen)
{
	bool bInterrupt = false ;
	*pDelLen = 0 ;
	int iLen = 4 ;

	BYTE pExpBuf[MEMLNK_DEF_BUFFER_SIZE*2] = {0} ;
	INT iExpLen = ExpDualization( pBuffer, iLength, pExpBuf ) ;

	if( m_stSetting.bOneByOne )
	{
		if( iExpLen <= 1 )
		{	//	not yet
			return FALSE ;
		}
		bInterrupt = (pExpBuf[1] == 'I') ? true : false ;
	}
	else
	{
		if( iExpLen <= 4 )
		{	//	not yet
			return FALSE ;
		}
		if( (CheckMachineNum(&pBuffer[1])) &&
			(pExpBuf[2] == MEMLNK_DEF_ESC) &&
			(pExpBuf[3] == 'I') )
		{
			bInterrupt = true ;
		}
		iLen += 2 ;
	}

	if( bInterrupt && (iExpLen < iLen) )
	{	//	not yet
		return FALSE ;
	}

	*pDelLen = 1 ;
	if( !bInterrupt )
	{	//	not wait command
		return FALSE ;
	}

	BYTE* pPos = pExpBuf + 2 ;
	if( !m_stSetting.bOneByOne )
	{
		pPos += 2 ;
	}

	pstReply->wCount = *pPos++ ;
	pstReply->wData = *pPos/*++*/ ;

	return TRUE ;
}


/*===================================================*/
//	Transmit
//	---------------------------------------------------
//		Transmit buffer
/*===================================================*/
int CMemlinkSio::Transmit(BYTE* Buf, INT iLen, MTOMSIOCALLBACK pfReceive, LPVOID pParam)
{
	ASSERT( IsOpen() ) ;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE*2] = {0} ;
	INT iTxLen = Dualization( Buf, iLen, TxBuf ) ;

	//	Clear Tx and Rx Buffer
	m_pSock->BufferClear() ;
	m_iRxLen = 0 ;

	DWORD dwWrote = 0 ;
	if( !m_pSock->Write( TxBuf, (DWORD)iTxLen, &dwWrote ) || (dwWrote != (DWORD)iTxLen) )
	{
		return SIO_MTOM_ERR_SEND ;
	}

	if( pfReceive || (m_stSetting.bAck && m_stSetting.bNak) )
	{
		if( pfReceive == NULL )
		{
			pfReceive = CB_ReceiveAckNak ;
		}
		//	have to wait reply
		DWORD dwStartTick = ::GetTickCount() ;
		DWORD dwRead = 0 ;
		int iRet = SIO_MTOM_ERROR_TOUT_RES;
		int iDetail = 0;
		while( difftime( ::GetTickCount(), dwStartTick ) < MEMLNK_TIMEOUT_TICK )
		{
			if( m_pSock->Read( &m_RxBuf[m_iRxLen], MEMLNK_DEF_BUFFER_SIZE-m_iRxLen, &dwRead ) && dwRead )
			{
				m_iRxLen += dwRead ;
				//	Receive Data
				if( pfReceive( this, &iRet, &iDetail, pParam ) )
				{
					break ;
				}
			}
			PumpMessage(1) ;
		}
		if( iRet != SIO_MTOM_OK )
		{
			m_iErrDetail = iDetail ;
		}
		return iRet ;
	}

	return SIO_MTOM_OK ;
}


/*===================================================*/
//	CalculateChecksum
//	---------------------------------------------------
//		calculate sum
/*===================================================*/
BYTE CMemlinkSio::CalculateChecksum(BYTE* Buffer, INT iLen)
{
	unsigned long ulSum = 0;
	while( iLen > 0 )
	{
		ulSum += Buffer[--iLen] ;
	}

	return (BYTE)(ulSum & 0xFF) ;
}


/*===================================================*/
//	Dualization
//	---------------------------------------------------
//		Dualize buffer
/*===================================================*/
INT CMemlinkSio::Dualization(BYTE* SrcBuf, INT iSrcLen, BYTE* DestBuf)
{
	INT iDestLen = 0 ;
	if( iSrcLen <= 0 )
	{
		ASSERT( 0 ) ;
		return iDestLen ;
	}

	if( !m_stSetting.bOneByOne && !m_stSetting.bAscii )
	{
		//	1:n Bin
		INT iLen = 0 ;
		DestBuf[iDestLen++] = SrcBuf[iLen++] ;
		while( iLen < iSrcLen )
		{
			if( SrcBuf[iLen] == MEMLNK_DEF_ENQ )
			{
				//	ENQ : be double
				DestBuf[iDestLen++] = MEMLNK_DEF_ENQ ;
			}
			DestBuf[iDestLen++] = SrcBuf[iLen++] ;
		}
	}
	else
	{
		//	no need
		memcpy( DestBuf, SrcBuf, iSrcLen ) ;
		iDestLen = iSrcLen ;
	}

	ASSERT( iDestLen >= iSrcLen ) ;
	return iDestLen ;
}


/*===================================================*/
//	ExpDualization
//	---------------------------------------------------
//		Exp Dualize buffer
/*===================================================*/
INT CMemlinkSio::ExpDualization(BYTE* SrcBuf, INT iSrcLen, BYTE* DestBuf)
{
	INT iDestLen = 0 ;
	if( iSrcLen <= 0 )
	{
		ASSERT( 0 ) ;
		return iDestLen ;
	}

	if( !m_stSetting.bOneByOne && !m_stSetting.bAscii )
	{
		//	1:n Bin
		INT iLen = 0 ;
		while( iLen < iSrcLen )
		{
			if( (iLen+1 < iSrcLen) &&
				(SrcBuf[iLen] == MEMLNK_DEF_STX) &&
				(SrcBuf[iLen+1] == MEMLNK_DEF_STX))
			{
				//	STX : double
				iLen++ ;
			}
			DestBuf[iDestLen++] = SrcBuf[iLen++] ;
		}
	}
	else
	{
		//	no need
		memcpy( DestBuf, SrcBuf, iSrcLen ) ;
		iDestLen = iSrcLen ;
	}

	ASSERT( iDestLen <= iSrcLen ) ;
	return iDestLen ;
}


/*===================================================*/
//	ShiftBuffer
//	---------------------------------------------------
//		Shift Buffer
/*===================================================*/
INT CMemlinkSio::ShiftBuffer(BYTE* Buf, INT iLen, INT iShiftLen)
{
	if( iLen <= iShiftLen )
	{
		return 0 ;
	}
	if( iShiftLen <= 0 )
	{
		return iLen ;
	}

	INT iRest = iLen - iShiftLen ;
	for( INT i = 0; i < iRest; i++ )
	{
		Buf[i] = Buf[i+iShiftLen] ;
	}

	return iRest ;
}


/*===================================================*/
//	AsciiColor
//	---------------------------------------------------
//		Change color to ASCII
/*===================================================*/
INT CMemlinkSio::AsciiColor(GPCOLOR cColor,BYTE* Buf)
{
	INT iLen = 0 ;

	BYTE byBlink = 0 ;
	BYTE byColor = (BYTE)(cColor&0x3F) ;
	switch( cColor >> 6 )
	{
	default :
		ASSERT( 0 ) ;
	case 0 :
		byBlink = 0 ;		break ;
	case 1 :
		byBlink = 2 ;		break ;
	case 2 :
		byBlink = 1 ;		break ;
	case 3 :
		byBlink = 3 ;		break ;
	}

	Buf[iLen++] = '0' + byBlink ;
	Buf[iLen++] = '0' + byColor ;

	return iLen ;
}


/*===================================================*/
//	AsciiColorEx
//	---------------------------------------------------
//		Change color to ASCII
/*===================================================*/
INT CMemlinkSio::AsciiColorEx(GPCOLOR cColor,BYTE* Buf)
{
	INT iLen = 0 ;

	BYTE byBlink = 0 ;
	BYTE byColor = (BYTE)(cColor&0x3F) ;
	switch( cColor >> 6 )
	{
	default :
		ASSERT( 0 ) ;
	case 0 :
		byBlink = 0 ;		break ;
	case 1 :
		byBlink = 2 ;		break ;
	case 2 :
		byBlink = 1 ;		break ;
	case 3 :
		byBlink = 3 ;		break ;
	}

	Buf[iLen++] = '0' + byBlink ;
	Buf[iLen++] = '0' + byColor/10 ;
	Buf[iLen++] = '0' + byColor%10 ;

	return iLen ;
}


/*===================================================*/
//	AsciiDec
//	---------------------------------------------------
//		Change dec to ASCII
/*===================================================*/
INT CMemlinkSio::AsciiDec(INT iNum,INT iLen,BYTE* Buf)
{
	char str[100] = {0} ;
	sprintf(str,"%d",iNum) ;
	INT iNumLen = strlen(str) ;
	if( iNumLen >= iLen )
	{
		ASSERT( iNumLen == iLen ) ;
		memcpy( Buf, &str[iNumLen-iLen], iLen ) ;
	}
	else
	{
		memset( Buf, '0', iLen - iNumLen ) ;
		memcpy( &Buf[iLen - iNumLen], str, iNumLen ) ;
	}

	return iLen ;
}


/*===================================================*/
//	AsciiHex
//	---------------------------------------------------
//		Change hex to ASCII
/*===================================================*/
INT CMemlinkSio::AsciiHex(INT iNum,INT iLen,BYTE* Buf)
{
	char str[100] = {0} ;
	sprintf(str,"%X",iNum) ;
	INT iNumLen = strlen(str) ;
	if( iNumLen >= iLen )
	{
		ASSERT( iNumLen == iLen ) ;
		memcpy( Buf, &str[iNumLen-iLen], iLen ) ;
	}
	else
	{
		memset( Buf, '0', iLen - iNumLen ) ;
		memcpy( &Buf[iLen - iNumLen], str, iNumLen ) ;
	}

	return iLen ;
}


/*===================================================*/
//	AsciiHex
//	---------------------------------------------------
//		Change hex to ASCII
/*===================================================*/
int CMemlinkSio::ESC_SetContrast_Sub(WORD wAttribute,WORD wValue)
{
	EX_INT_CHECK_OPEN ;

	BYTE TxBuf[MEMLNK_DEF_BUFFER_SIZE] ;
	INT iPos = AddHead( TxBuf ) ;

	TxBuf[iPos++] = MEMLNK_DEF_ESC ;
	TxBuf[iPos++] = '#' ;

	if( m_stSetting.bAscii )
	{
		//	ASCII
		iPos += AsciiDec( wAttribute, 4, &TxBuf[iPos] ) ;
		iPos += AsciiDec( wValue, 4, &TxBuf[iPos] ) ;
	}
	else
	{
		//	Binary
		TxBuf[iPos++] = (BYTE)(wAttribute/0x100) ;
		TxBuf[iPos++] = (BYTE)(wAttribute&0xFF) ;
		TxBuf[iPos++] = (BYTE)(wValue/0x100) ;
		TxBuf[iPos++] = (BYTE)(wValue&0xFF) ;
	}

	//	Add Footer
	iPos += AddFoot( TxBuf, iPos ) ;

	return Transmit( TxBuf, iPos, NULL, NULL ) ;
}


/*===================================================*/
//	CheckMachineNum
//	---------------------------------------------------
//		Check Machine Num
/*===================================================*/
BOOL CMemlinkSio::CheckMachineNum(BYTE* pBuffer)
{
	ASSERT( !m_stSetting.bOneByOne ) ;

	BOOL bRet = FALSE ;
	if( m_stSetting.bAscii )
	{
		int iNum = 0xFF;
		char strNum[3] = {0} ;
		memcpy( strNum, pBuffer, 2 ) ;
		sscanf( strNum, "%X", &iNum ) ;
		bRet = ( iNum == (int)m_stSetting.byMachineNum ) ? TRUE : FALSE ;
	}
	else
	{
		bRet = ( *pBuffer == m_stSetting.byMachineNum ) ? TRUE : FALSE ;
	}

	return bRet ;
}


/*===================================================*/
//	GetAsciiPacket
//	---------------------------------------------------
//		Get Packet from buffer
/*===================================================*/
#define MENLNK_MAC_SERCH_NEXT	{																						\
									iStart++ ;																			\
									BOOL bRet = GetAsciiPacket( &SrcBuf[iStart], iSrcLen - iStart, piStart, piLen ) ;	\
									if( bRet ){	(*piStart) += iStart;	}												\
									return bRet ;																		\
								}
BOOL CMemlinkSio::GetAsciiPacket(BYTE* SrcBuf, INT iSrcLen, INT *piStart, INT* piLen)
{
	if( iSrcLen <= 0 )
	{
		return FALSE ;
	}

	//	set Start Char
	BYTE byStart = m_stSetting.bOneByOne ? MEMLNK_DEF_ESC : MEMLNK_DEF_STX ;

	INT iStart = 0;
	for( iStart = 0; iStart < iSrcLen; iStart++ )
	{
		if( (SrcBuf[iStart] == byStart) ||
			(SrcBuf[iStart] == MEMLNK_DEF_ACK) ||
			(SrcBuf[iStart] == MEMLNK_DEF_NAK) )
		{
			break ;
		}
	}
	if( iStart >= iSrcLen )
	{
		//	not yet
		return FALSE ;
	}

	//	Serch CF
	INT iLen = 1;
	for( iLen = 1; iStart + iLen < iSrcLen; iLen++ )
	{
		if( SrcBuf[iStart + iLen] == MEMLNK_DEF_CR )
		{
			if( !m_stSetting.bCrLf ||
				((iStart + iLen + 1 < iSrcLen) && (SrcBuf[iStart + iLen + 1] == MEMLNK_DEF_LF) ) )
			{
				break ;
			}
		}

		if( (SrcBuf[iStart + iLen] == byStart) ||
			(SrcBuf[iStart + iLen] == MEMLNK_DEF_ACK) ||
			(SrcBuf[iStart + iLen] == MEMLNK_DEF_NAK) )
		{
			//	Start Char -> New Packet
			MENLNK_MAC_SERCH_NEXT ;	//	return in the MACRO
		}
	}
	if( iStart + iLen >= iSrcLen )
	{
		//	not yet
		return FALSE ;
	}

	//	1:N -> Check MachineNum
	if( !m_stSetting.bOneByOne )
	{
		bool bComplete = true ;
		if( iLen < 3 )
		{
			//	format is NG!!
			bComplete = false ;
		}
		else
		{
			int iNum = 0xFF;
			char strNum[3] = {0} ;
			memcpy( strNum, &SrcBuf[iStart+1], 2 ) ;
			sscanf( strNum, "%X", &iNum ) ;
			if( iNum != (int)m_stSetting.byMachineNum )
			{
				bComplete = false ;
			}
		}

		if( !bComplete )
		{
			MENLNK_MAC_SERCH_NEXT ;	//	return in the MACRO
		}
	}

	//	Set
	*piStart = iStart ;
	*piLen = m_stSetting.bCrLf ? (iLen+2) : (iLen+1) ;
	
	return TRUE ;
}


/*===================================================*/
//	GetBinPacket
//	---------------------------------------------------
//		Get Packet from buffer
/*===================================================*/
BOOL CMemlinkSio::GetBinPacket(BYTE* SrcBuf, INT iSrcLen, INT *piStart, INT* piLen)
{
	if( iSrcLen <= 0 )
	{
		return FALSE ;
	}

	//	set Start Char
	BYTE byStart = m_stSetting.bOneByOne ? MEMLNK_DEF_ESC : MEMLNK_DEF_STX ;

	INT iStart = 0;
	for( iStart = 0; iStart < iSrcLen; iStart++ )
	{
		if( (SrcBuf[iStart] == byStart) ||
			(SrcBuf[iStart] == MEMLNK_DEF_ACK) ||
			(SrcBuf[iStart] == MEMLNK_DEF_NAK) )
		{
			if( (byStart == MEMLNK_DEF_STX) &&
				(SrcBuf[iStart] == byStart) &&
				(SrcBuf[iStart+1] == byStart) )
			{
			}
			break ;
		}
	}
	if( iStart >= iSrcLen )
	{
		//	not yet
		return FALSE ;
	}

	//	Serch CF
	INT iLen = 1;
	for( iLen = 1; iStart + iLen < iSrcLen; iLen++ )
	{
		if( SrcBuf[iStart + iLen] == MEMLNK_DEF_CR )
		{
			if( !m_stSetting.bCrLf ||
				((iStart + iLen + 1 < iSrcLen) && (SrcBuf[iStart + iLen + 1] == MEMLNK_DEF_LF) ) )
			{
				break ;
			}
		}

		if( (SrcBuf[iStart + iLen] == byStart) ||
			(SrcBuf[iStart + iLen] == MEMLNK_DEF_ACK) ||
			(SrcBuf[iStart + iLen] == MEMLNK_DEF_NAK) )
		{
			//	Start Char -> New Packet
			MENLNK_MAC_SERCH_NEXT ;	//	return in the MACRO
		}
	}
	if( iStart + iLen >= iSrcLen )
	{
		//	not yet
		return FALSE ;
	}

	//	1:N -> Check MachineNum
	if( !m_stSetting.bOneByOne )
	{
		bool bComplete = true ;
		if( iLen < 3 )
		{
			//	format is NG!!
			bComplete = false ;
		}
		else
		{
			int iNum = 0xFF;
			char strNum[3] = {0} ;
			memcpy( strNum, &SrcBuf[iStart+1], 2 ) ;
			sscanf( strNum, "%X", &iNum ) ;
			if( iNum != (int)m_stSetting.byMachineNum )
			{
				bComplete = false ;
			}
		}

		if( !bComplete )
		{
			MENLNK_MAC_SERCH_NEXT ;	//	return in the MACRO
		}
	}

	//	Set
	*piStart = iStart ;
	*piLen = m_stSetting.bCrLf ? (iLen+2) : (iLen+1) ;

	return TRUE ;
}

